/**
 * Player component.
 *
 */

'use strict';

import PlayerComponent from "mihbbtv/lib/components/player";
import Player from "./hbbPlayer";

class AppPlayer extends PlayerComponent {

  load(cfg) {
    //cleanup first
    // this.init();

    if (! cfg) {
      cfg = this.config;
    }

    const play = () => {
      // console.log(`player play`);

      this.player.exitPlayerCb = cfg.exitPlayerCb || this.config.exitPlayerCb;
      this.player.startPlayerCb = cfg.startPlayerCb || this.config.startPlayerCb;
      this.player.fadeControls = false;
      this.player.enableGa();
      this.player.initPlaylist(cfg.playlist, cfg.videoType, cfg);
      this.player.playPlaylist(0, cfg);
    };

    if (this.player) {
      // console.log(`Player STOP`, this.player);

      this.player.stopVideo();
      this.player.clearVideo(play);
    } else {
      this.elm.innerHTML = this.markup();
      this.player = new Player(Player.DRIVER_TYPES.AUTO);

      return play();
    }
  }

  currentMedia() {
    if (! (this.player && this.player.driver)) {
      return false;
    }

    return this.player.driver.getSource();
  }

  isPlayling() {
    if (! this.player) {
      return false;
    }

    return this.player.driver.getState() === Player.STATE.PLAYING;
  }

  isPaused() {
    if (! this.player) {
      return false;
    }

    return this.player.driver.getState() === Player.STATE.PAUSED;
  }

  stop() {
    if (! this.player) {
      return false;
    }

    this.player.stopVideo();
  }

  pausePlay() {
    if (! this.player) {
      return false;
    }

    this.player.pausePlayVideo();
  }

  forward() {
    if (! this.player) {
      return false;
    }

    this.player.seekVod(60, true);
  }

  backward() {
    if (! this.player) {
      return false;
    }

    this.player.seekVod(60, false);
  }

  markup() {
    return '<div class="player" id="player">' +
                '<div id="videoContainer" class="videoContainer"></div>' +
                '<div class="shadow"></div>' +

                '<div class="GUI" id="playerGUI">' +
                    '<div class="control-wrap">' +
                        '<div id="home" class="control home">' +
                        '</div>' +
                        '<div id="play-pause" class="control play">' +
                        '</div>' +
                        '<div id="seek-btn" class="control start">' +
                        '</div>' +
                        '<div id="settings" class="control setting">' +
                            '<ul class="settings-box" id="setting-box">' +
                                '<li></li>' +
                            '</ul>' +
                        '</div>' +
                        '<div id="more" class="control more">' +
                        '</div>' +
                    '</div>' +

                '</div>' +
                '<div class="loader" id="player-loader"></div>' +
            '</div>';
  }

}

export default AppPlayer;
