/**
 * Error scene.
 *
 * @author: Vaclav Hradec <vaclav@mihybrid.com>
 */
 'use strict';

import App from "mihbbtv/lib/hbbtv/application";
import AppScene from "../appScene";
import Modal from 'mihbbtv/lib/components/modal';

import acts from './acts';

class ErrorScene extends AppScene {

  constructor() {
    super('error', acts);

    this.defaultAct = 0;
    this.overlay = true;
  }

	/**
	 * Show scene.
	 *
	 * @param {Integer} prev
	 * @param {Function} done
	 * @returns {void}
	 */
	show (prev, done) {
    this.prev = prev;

    App.loader.show();
    App.mainMenu.activate(null);

    if (! this.params.error) {
      this.params.error = {
        heading: 'Chyba',
        msg: 'Bohužel, vyskytla se chyba. Zkuste prosím načíst aplikaci později.'
      };
    }

    this.modal = new Modal('errorWinModal', this.elm, {
      itemClasses: 'error',
      title: this.params.error.heading,
    });
    const modalContainer = this.modal.getContainer();
    const h2 = document.createElement('h2');
    h2.innerText = this.params.error.msg;
    modalContainer.appendChild(h2);

    App.loader.hide();

    return done();
	}

  hide() {
    delete this.modal;

    // free all scene DOM elements
    this.elm.innerHTML = '';

    // ugly hack to get user to home scene from overlay
    if (0 === this.prev) {
      // console.log(App.scenes[this.prev]);
      App.scenes[this.prev].hideMethod();
      App.setScene('home');
    }
  }

}

export default ErrorScene;
