<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:sds="http://eHealth.gov.sk/SDS/v1" 
                xmlns:sds2="http://eHealth.gov.sk/SDS/v2"
                xmlns:jruz="http://eHealth.gov.sk/JRUZ/v1"
                xmlns:pdm="http://eHealth.gov.sk/EzkPersonalDataManagement/v1"
                xmlns:ehr="CEN/13606/RM">
    
    <xsl:output method="html" indent="yes"/>

    <xsl:template match="/">
        <html>
            <head>
                <style>
                    body{margin:0;padding:0;width:750px}
                    dl{margin:0;padding:0}
                    dl dd,dl dt{margin-bottom:4px;font-size: 10pt}
                    dl dd{margin-left:85px}
                    .half dd{margin-left:130px}
                    dl dt{float:left;width:85px}
                    .half dt{width: 130px;}
                    table{width:100%;border-collapse:collapse}
                    td{padding:0}
                    thead.pageHeader th{padding-bottom:10px}
                    thead.pageHeader th div{background-color:#fff5cc;border:1px solid #333; padding: 5px 0}
                    .tableItem table{border:1px solid #555;border-collapse:collapse;font-size:10pt}
                    .tableItem thead tr{border:1px solid #555}
                    .tableItem tr td{border:1px solid #555;padding:1px}
                    .sectionTitle,.tableItem .itemTitle{border-left:1px solid #555;border-right:1px solid #555;padding:6px 10px;background-color:#e4e4e4;font-weight:700;font-size:11pt}
                    .detailItem{border-bottom:1px dashed #ccc;padding-bottom:5px}
                    .detailItem.last{border-bottom-width:0px}
                    .detailItem .itemTitle{font-style:italic;font-weight:700;padding:5px 10px;font-size:11pt}
                    .sectionTitle{border:1px solid #555;margin-top:8px;font-size:12pt}
                    .sectionTitle:first-child{margin-top:0}
                    .horizontalSep{color:#888;background-color:#888;height:1px;border-width:0px}
                    .left{float:left}
                    .half{width:50%}
                    .third{width:33%}
                    .clear{clear:both}
                </style>
            </head>
            
            <body>
                <table>
                    <thead class="pageHeader">
                        <tr>
                            <th>
                                <div>
                                    <xsl:value-of select="./DocumentData/PatientBasicInfo/sds:SDSEnvelope//jruz:PersonData/jruz:PhysicalPerson/jruz:PersonName/jruz:FormattedName"/>,
                                    <xsl:value-of select="./DocumentData/PatientBasicInfo/sds:SDSEnvelope//jruz:PersonData/jruz:ID/jruz:IdentifierValue"/>,                                    
                                    <xsl:value-of select="./DocumentData/PatientBasicInfo/sds:SDSEnvelope//jruz:PersonData/jruz:PhysicalPerson/jruz:Sex/jruz:displayName"/>,
                                    <xsl:value-of select="./DocumentData/PatientBasicInfo/sds:SDSEnvelope//jruz:ZdravotnePoistenie/jruz:NazovZP"/>
                            </div>
                            </th>
                        </tr>
                    </thead>
                    
                    <tbody>
                        <tr>
                            <td>
                                <div class="section">
                                    <xsl:for-each select="./DocumentData/Sections/Section">
                                        <xsl:apply-templates select="."/>
                                    </xsl:for-each>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="Section">
        <xsl:if test="./Title">
            <div class="sectionTitle">
                <xsl:value-of select="./Title"/>
            </div>
        </xsl:if>

        <xsl:for-each select="./sds2:SDSEnvelope//PatientContactICE">
            <xsl:apply-templates select="."/>
        </xsl:for-each>
        
        <xsl:for-each select="./Items/Item">
            <xsl:apply-templates select="."/>
        </xsl:for-each>
    </xsl:template>

    <!-- Template used for rendering contacts data -->
    <xsl:template match="PatientContactICE">
        <div class="detailItem last">
            <div class="itemTitle">
                <xsl:choose>
                    <xsl:when test="./pdm:JeICEKontakt[text() = 'true']">
                        ICE kontakt
                    </xsl:when>
                    <xsl:otherwise>
                        Kontaktný údaj
                    </xsl:otherwise>
                </xsl:choose>                
            </div>
            <xsl:if test="./pdm:JeICEKontakt[text() = 'true']">
                <div>
                    <dl class="left half">
                        <dt>
                            Meno a priezvisko:
                        </dt>
                        <dd>
                            <xsl:value-of select="./pdm:TitulPred//ehr:displayName"/>
                            <xsl:if test="./pdm:TitulPred//ehr:displayName">
                                &#160;
                            </xsl:if>
                            <xsl:value-of select="./pdm:Meno"/>&#160;<xsl:value-of select="./pdm:Priezvisko"/>                         
                            <xsl:if test="./pdm:TitulZa//ehr:displayName">
                                &#160;
                            </xsl:if>
                            <xsl:value-of select="./pdm:TitulZa//ehr:displayName"/>
                        </dd>
                    </dl>
                    <dl class="left half">
                        <dt>
                            Vzťah:
                        </dt>
                        <dd>
                            <xsl:value-of select="./pdm:Vztah//ehr:displayName"/>
                        </dd>
                    </dl>                   
                    <div class="clear"></div>
                </div>
            </xsl:if>
            <div>
                <dl class="left half">
                    <dt>
                        Telefón:
                    </dt>
                    <dd>
                        <xsl:value-of select="./pdm:Telefon"/>
                    </dd>
                </dl>
                <dl class="left half">
                    <dt>
                        E-mail:
                    </dt>
                    <dd>
                        <xsl:value-of select="./pdm:EMail"/>
                    </dd>
                </dl>                
                <div class="clear"></div>
            </div>          
            <div>
                <dl class="left half">
                    <dt>
                        Ulica a číslo:
                    </dt>
                    <dd>
                        <xsl:value-of select="./pdm:Ulica"/>&#160;<xsl:value-of select="./pdm:Cislo"/>
                    </dd>
                </dl>
                <dl class="left half">
                    <dt>
                        Mesto:
                    </dt>
                    <dd>
                        <xsl:value-of select="./pdm:Mesto//ehr:displayName"/>
                    </dd>
                </dl>                
                <div class="clear"></div>
            </div>
            <div>
                <dl class="left half">
                    <dt>
                        PSČ:
                    </dt>
                    <dd>
                        <xsl:value-of select="./pdm:Psc//ehr:displayName"/>
                    </dd>
                </dl>
                 <dl class="left half">
                    <dt>
                        Okres:
                    </dt>
                    <dd>
                        <xsl:value-of select="./pdm:Okres//ehr:displayName"/>                        
                    </dd>
                </dl>
                <div class="clear"></div>
            </div>
            <div>               
                <dl class="left half">
                    <dt>
                        Územnospr. jednotka:
                    </dt>
                    <dd>
                        <xsl:value-of select="./pdm:UzemnospravnaJednotka//ehr:displayName"/>
                    </dd>
                </dl>
                <dl class="left half">
                    <dt>
                        Štát:
                    </dt>
                    <dd>
                        <xsl:value-of select="./pdm:Stat//ehr:displayName"/>
                    </dd>
                </dl>
                <div class="clear"></div>
            </div>
            <div>
                <dl class="left half">
                    <dt>
                        Poznámka:
                    </dt>
                    <dd>
                        <xsl:value-of select="./pdm:Poznamka"/>
                    </dd>
                </dl>
                <xsl:if test="./pdm:JeICEKontakt[text() = 'false']">
                    <dl class="left half">
                        <dt>
                            Preferovaný kontakt:
                        </dt>
                        <dd>
                            <xsl:choose>
                                <xsl:when test="./pdm:PreferovanyKontakt[text() = 'true']">
                                    áno
                                </xsl:when>
                                <xsl:otherwise>
                                    nie
                                </xsl:otherwise>
                            </xsl:choose>        
                        </dd>
                    </dl>
                </xsl:if>
                <div class="clear"></div>
            </div>
        </div>
        <hr class="horizontalSep" />
    </xsl:template>
    
    <!-- Template used for rendering child -->
    <xsl:template match="Item[@SectionType='DetailViewInfo'] | Child[@SectionType='DetailViewInfo']">
        <xsl:param name="cssClass" select="@CssClass"/>
        <div class="detailItem {$cssClass}">
            <xsl:if test="./Title">
                <div class="itemTitle">
                    <xsl:value-of select="./Title"/>
                </div>
            </xsl:if>

            <xsl:choose>
                <xsl:when test="@Columns = 1">
                    <xsl:call-template name="dataLanguageSpec">
                        <xsl:with-param name="cssClasses" select="'left half'"/>
                        <xsl:with-param name="elements" select="./Items/Item[@ColumnNumber=0]"/>
                    </xsl:call-template>

                    <xsl:call-template name="dataLanguageSpec">
                        <xsl:with-param name="cssClasses" select="'left half'"/>
                        <xsl:with-param name="elements" select="./Items/Item[@ColumnNumber=1]"/>
                    </xsl:call-template>
                    
                    <div class="clear"></div>
                </xsl:when>

                <xsl:when test="@Columns = 2">
                    <xsl:call-template name="dataLanguageSpec">
                        <xsl:with-param name="cssClasses" select="'left third'"/>
                        <xsl:with-param name="elements" select="./Items/Item[@ColumnNumber=0]"/>
                    </xsl:call-template>

                    <xsl:call-template name="dataLanguageSpec">
                        <xsl:with-param name="cssClasses" select="'left third'"/>
                        <xsl:with-param name="elements" select="./Items/Item[@ColumnNumber=1]"/>
                    </xsl:call-template>

                    <xsl:call-template name="dataLanguageSpec">
                        <xsl:with-param name="cssClasses" select="'left third'"/>
                        <xsl:with-param name="elements" select="./Items/Item[@ColumnNumber=2]"/>
                    </xsl:call-template>

                    <div class="clear"></div>
                </xsl:when>

                <xsl:otherwise>
                    <xsl:call-template name="dataLanguageSpec">
                        <xsl:with-param name="cssClasses" select="''"/>
                        <xsl:with-param name="elements" select="./Items/Item"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>

    <xsl:template match="Item[@SectionType='TableViewInfo'] | Child[@SectionType='TableViewInfo']">
        <div class="tableItem">
            <xsl:if test="./Title">
                <div class="itemTitle">
                    <xsl:value-of select="./Title"/>
                </div>
            </xsl:if>

            <table>
                <thead>
                    <tr>
                        <xsl:for-each select="./Columns/Column">
                            <th>
                                <xsl:attribute name="style">
                                    <xsl:value-of select="concat('width:', @Width, 'px;')"/>
                                </xsl:attribute>
                                <xsl:value-of select="./Title"/>
                            </th>
                        </xsl:for-each>
                    </tr>
                </thead>
                <tbody>
                    <xsl:for-each select="./Data/Row">
                        <tr>
                            <xsl:for-each select="./string">
                                <td>
                                    <xsl:value-of select="."/>
                                </td>
                            </xsl:for-each>
                        </tr>
                    </xsl:for-each>
                </tbody>
            </table>
        </div>
    </xsl:template>

    <xsl:template match="Item[@SectionType='HorizontalSeparator']">
        <hr class="horizontalSep"/>
    </xsl:template>

    <!-- Template for rendering detail DL DT DD elements inside of div -->
    <xsl:template name="dataLanguageSpec">
        <xsl:param name="elements"/>
        <xsl:param name="cssClasses"/>
        
        <div>
            <xsl:attribute name="class">
                <xsl:value-of select="$cssClasses"/>
            </xsl:attribute>

            <xsl:for-each select="$elements">
                <div>
                    <dl>
                        <dt>
                            <xsl:value-of select="./Label"/>:
                        </dt>
                        <dd>
                            <xsl:value-of select="./Value"/>
                        </dd>
                    </dl>
                    <div class="clear"></div>
                </div>
            </xsl:for-each>
        </div>
    </xsl:template>
</xsl:stylesheet>
