package sk.kosice.konto.kknotificationservice.mailjet.configuration;

import com.mailjet.client.ClientOptions;
import com.mailjet.client.MailjetClient;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import sk.kosice.konto.kknotificationservice.domain.shared.utils.SecretUtils;
import sk.kosice.konto.kknotificationservice.mailjet.configuration.properties.MailjetClientPropertiesPort;

@Configuration
public class MailjetClientConfiguration {

  @Profile("!test")
  @Bean
  public MailjetClient mailjetClient(MailjetClientPropertiesPort mailjetClientPropertiesPort) {
    final OkHttpClient customHttpClient =
        new OkHttpClient.Builder()
            .connectTimeout(60, TimeUnit.SECONDS)
            .readTimeout(60, TimeUnit.SECONDS)
            .writeTimeout(60, TimeUnit.SECONDS)
            .build();

    final ClientOptions clientOptions =
        ClientOptions.builder()
            .apiKey(SecretUtils.resolveSecretValue(mailjetClientPropertiesPort.apiKey()))
            .apiSecretKey(SecretUtils.resolveSecretValue(mailjetClientPropertiesPort.secretKey()))
            .okHttpClient(customHttpClient)
            .build();

    return new MailjetClient(clientOptions);
  }
}
