package sk.kosice.konto.kknotificationservice.mailjet.error;

import static sk.kosice.konto.kknotificationservice.domain.common.error.ErrorCodeType.BAD_REQUEST;
import static sk.kosice.konto.kknotificationservice.domain.common.error.ErrorCodeType.FORBIDDEN;
import static sk.kosice.konto.kknotificationservice.domain.common.error.ErrorCodeType.INTERNAL;
import static sk.kosice.konto.kknotificationservice.domain.common.error.ErrorCodeType.UNAUTHORIZED;

import sk.kosice.konto.kknotificationservice.domain.common.error.ErrorCode;
import sk.kosice.konto.kknotificationservice.domain.common.error.ErrorCodeType;

public enum MailjetClientErrorCode implements ErrorCode {
  MAILJET_CLIENT_INTERNAL_ERROR(INTERNAL, "Error sending email with Mailjet client, detail: %s."),
  MAILJET_CLIENT_UNAUTHORIZED(UNAUTHORIZED, "Error sending email, credential are invalid."),
  MAILJET_CLIENT_FORBIDDEN(FORBIDDEN, "Error sending email, permissions error."),
  MAILJET_CLIENT_BAD_REQEUEST(BAD_REQUEST, "Error sending email, check your input: %s");

  private final ErrorCodeType type;
  private final String template;

  MailjetClientErrorCode(ErrorCodeType type, String template) {
    this.type = type;
    this.template = template;
  }

  @Override
  public String template() {
    return this.template;
  }

  @Override
  public ErrorCodeType type() {
    return this.type;
  }
}
