'use client';

import React from 'react';
import { useTranslations } from 'next-intl';
import { ErrorDialog, PrimaryButton, SecondaryButton } from '@/lib/idsk';
import { Address } from '@/utils';

interface DeleteAddressDialogProps {
  address: Address | null;
  onSubmit: () => void;
  onCancel: () => void;
}

const DeleteAddressDialog: React.FC<DeleteAddressDialogProps> = ({ address, onSubmit, onCancel }) => {
  const t = useTranslations('my_data');

  return (
    <ErrorDialog
      title={t(`delete_title_${address?.type || 'default'}`)}
      subtitle={t(`delete_subtitle_${address?.type || 'default'}`)}
      opened={!!address}
      img={null}
    >
      <PrimaryButton variant="warning" onClick={onSubmit}>
        {t('yes_delete')}
      </PrimaryButton>
      <SecondaryButton onClick={onCancel}>{t('cancel')}</SecondaryButton>
    </ErrorDialog>
  );
};

export default DeleteAddressDialog;
