'use client';

import React, { useState } from 'react';
import { useTranslations } from 'next-intl';
import Link from 'next/link';
import { useSession } from 'next-auth/react';
import { BaseButton, HeaderContainer, Logo, MenuButton, MenuMobile, Navigation, PrimaryButton } from '@/lib/idsk';

import { useLocalLink } from '@/hooks';
import SecondaryHeader from './SecondaryHeader';
import LogoKosice from '@/assets/logo_kosice.svg';
import PrimaryNavigation from './PrimaryNavigation';

const Header: React.FC = () => {
  const [opened, setOpened] = useState<boolean>(false);
  const t = useTranslations();

  const href = useLocalLink();

  const session = useSession();
  const isLogged = session.status === 'authenticated' && session.data && !session.data.error;
  const user = isLogged && !session.data.error ? session.data?.user : undefined;

  return (
    <HeaderContainer
      fixed
      secondaryNavigation={<SecondaryHeader />}
      mobileMenu={
        <MenuMobile opened={opened}>
          <h3 className="my-5">{`${user?.name} ${user?.surname}`}</h3>
          <Navigation label="Menu">
            <PrimaryNavigation />
          </Navigation>
          <div className="my-4 w-full">
            <Link href="/logout">
              <PrimaryButton variant="warning" fullWidth>
                {t('log_out')}
              </PrimaryButton>
            </Link>
          </div>
        </MenuMobile>
      }
      logo={
        <Link href={href('/')}>
          <Logo title="Moje Košice" image={<LogoKosice />} />
        </Link>
      }
    >
      {isLogged ? (
        <>
          <Navigation className="hidden dm1:flex">
            <PrimaryNavigation />
          </Navigation>

          <div className="ml-auto hidden dm1:flex flex-col items-end mt-auto mb-7">
            {user && <b className="leading-4">{`${user.name} ${user.surname}`}</b>}
            <Link href="/logout">
              <BaseButton className="idsk-link-m text-primary-medium text-base leading-4">{t('log_out')}</BaseButton>
            </Link>
          </div>

          <MenuButton
            className="dm1:hidden ml-auto"
            opened={opened}
            toggleOpened={() => setOpened((p) => !p)}
            openedTitle={t('close')}
            closedTitle={t('menu')}
          />
        </>
      ) : (
        <Link href="/signin" className="ml-auto">
          <PrimaryButton>{t('login')}</PrimaryButton>
        </Link>
      )}
    </HeaderContainer>
  );
};

export default Header;
