'use client';

import { createContext, useContext } from 'react';
import { SnackbarProps } from '@/lib/idsk';

interface NotificationsContextType {
  notifications: SnackbarProps[];
  notify: (notification: string | SnackbarProps) => void;
}

export const NotificationsContext = createContext<NotificationsContextType | null>(null);

export const useNotificationsContext = () => {
  const ctx = useContext(NotificationsContext);
  if (!ctx) {
    throw new Error('useNotifications must be used within a NotificationsProvider');
  }
  return ctx;
};
