import axios from 'axios';
import { useQuery } from '@tanstack/react-query';
import { api, Organization, Page, RequestError } from '@/utils';

const QUERY_KEY = ['subscriptions'];

const getSubscriptions = async (userId: string) => {
  const { data } = await axios.get<Page<Organization>>(api.organizationsForKid(userId));
  return data;
};

const useGetSubscriptions = (userId: string, options?: any) =>
  useQuery<Page<Organization>, RequestError>({
    queryKey: QUERY_KEY,
    queryFn: () => getSubscriptions(userId),
    ...options
  });

export default useGetSubscriptions;
