'use client';

import { useRef, useState } from 'react';

const useSearch = () => {
  const [value, setValue] = useState<string>('');

  const ref = useRef<HTMLInputElement>(null);

  const onSubmit = () => {
    const searchbar = ref.current;
    if (searchbar) {
      setValue(searchbar.value);
    }
  };

  const onCancel = () => {
    const searchbar = ref.current;
    if (searchbar) {
      searchbar.value = '';
      setValue('');
    }
  };

  return { ref, value, onSubmit, onCancel };
};

export default useSearch;
