package sk.kosice.konto.kknotificationservice.repository.recipient;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static sk.kosice.konto.kknotificationservice.domain.recipient.error.RecipientErrorCode.RECIPIENT_DOES_NOT_EXIST;

import java.util.UUID;
import org.junit.jupiter.api.Test;
import sk.kosice.konto.kknotificationservice.domain.common.error.BusinessException;
import sk.kosice.konto.kknotificationservice.domain.recipient.entity.RecipientEntity;

public class JooqRecipientRepositoryFindTest extends JooqRecipientRepositoryTest {

  @Test
  public void thatRecipientCanBeSelected() {
    final RecipientEntity insertData = prepareRecipientData();
    mergeRecipient(recipientRepository, insertData);

    final RecipientEntity result = findRecipient(recipientRepository, insertData.kid());

    assertThat(result).isNotNull();
    assertThat(result.kid()).isEqualTo(insertData.kid());
    assertThat(result.email()).isEqualTo(insertData.email());
  }

  @Test
  public void thatNotExistingRecipientCannotBeSelected() {
    final BusinessException exception =
        assertThrows(
            BusinessException.class, () -> findRecipient(recipientRepository, UUID.randomUUID()));

    assertThat(exception.getError().code().toString())
        .isEqualTo(RECIPIENT_DOES_NOT_EXIST.toString());
  }
}
