package sk.kosice.konto.kknotificationservice.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;
import sk.kosice.konto.kknotificationservice.restapi.config.OAuthPropertiesPort;

@Validated
@Configuration(proxyBeanMethods = false)
@ConfigurationProperties(prefix = "spring.security.oauth2.resourceserver.jwt")
public class OAuthPropertiesAdapter implements OAuthPropertiesPort {

  private String ocAppIntegrationIssuerLocation;
  private String ocAppIntegrationJwksUrl;

  @Override
  public String ocAppIntegrationIssuerLocation() {
    return ocAppIntegrationIssuerLocation;
  }

  @Override
  public String ocAppIntegrationJwksUrl() {
    return ocAppIntegrationJwksUrl;
  }

  public void setOcAppIntegrationIssuerLocation(String ocAppIntegrationIssuerLocation) {
    this.ocAppIntegrationIssuerLocation = ocAppIntegrationIssuerLocation;
  }

  public void setOcAppIntegrationJwksUrl(String ocAppIntegrationJwksUrl) {
    this.ocAppIntegrationJwksUrl = ocAppIntegrationJwksUrl;
  }
}
