package sk.kosice.konto.kknotificationservice.scheduler;

import static sk.kosice.konto.kkmessageservice.repository.model.Tables.MESSAGE;
import static sk.kosice.konto.kkmessageservice.repository.model.Tables.RECIPIENT;
import static sk.kosice.konto.kkmessageservice.repository.model.Tables.SUBSCRIPTION;
import static sk.kosice.konto.kkmessageservice.repository.model.Tables.TOPIC;

import java.time.OffsetDateTime;
import java.util.UUID;
import sk.kosice.konto.kknotificationservice.ServiceAppFeatureSpec;

public abstract class SchedulerFeatureSpec extends ServiceAppFeatureSpec {

  protected void prepareMessages() {
    final UUID kid1 = UUID.randomUUID();
    final UUID kid2 = UUID.randomUUID();
    final UUID topicId = UUID.randomUUID();
    dslContext.insertInto(RECIPIENT).values(kid1, "test@test.test").execute();
    dslContext.insertInto(RECIPIENT).values(kid2, "dsafdsfdsfe").execute();
    dslContext
        .insertInto(TOPIC)
        .values(topicId, "topicName", "topicDesc", UUID.randomUUID(), "organizationName")
        .execute();
    dslContext.insertInto(SUBSCRIPTION).values(UUID.randomUUID(), topicId, kid1, true).execute();
    dslContext.insertInto(SUBSCRIPTION).values(UUID.randomUUID(), topicId, kid2, true).execute();
    dslContext
        .insertInto(MESSAGE)
        .values(
            UUID.randomUUID(),
            UUID.randomUUID(),
            UUID.randomUUID().toString(),
            "title1",
            topicId,
            "content1",
            "TEXT",
            "short",
            null,
            null,
            kid1,
            OffsetDateTime.now(),
            false,
            "[\"KOSICE_BARCA\"]")
        .execute();
    dslContext
        .insertInto(MESSAGE)
        .values(
            UUID.randomUUID(),
            UUID.randomUUID(),
            UUID.randomUUID().toString(),
            "title2",
            topicId,
            "content2",
            "TEXT",
            "short",
            null,
            null,
            kid1,
            OffsetDateTime.now(),
            false,
            "[\"KOSICE_BARCA\"]")
        .execute();
    dslContext
        .insertInto(MESSAGE)
        .values(
            UUID.randomUUID(),
            UUID.randomUUID(),
            UUID.randomUUID().toString(),
            "title3",
            topicId,
            "content3",
            "TEXT",
            "short",
            null,
            null,
            kid1,
            OffsetDateTime.now(),
            true,
            "[\"KOSICE_BARCA\"]")
        .execute();
    dslContext
        .insertInto(MESSAGE)
        .values(
            UUID.randomUUID(),
            UUID.randomUUID(),
            UUID.randomUUID().toString(),
            "title3",
            topicId,
            "content3",
            "TEXT",
            "short",
            null,
            null,
            null,
            OffsetDateTime.now(),
            false,
            "[\"KOSICE_BARCA\"]")
        .execute();
    dslContext
        .insertInto(MESSAGE)
        .values(
            UUID.randomUUID(),
            UUID.randomUUID(),
            UUID.randomUUID().toString(),
            "title3",
            topicId,
            "withoutRecipient",
            "TEXT",
            "short",
            null,
            null,
            UUID.randomUUID(),
            OffsetDateTime.now(),
            false,
            "[\"KOSICE_BARCA\"]")
        .execute();
  }
}
