package sk.kosice.konto.kknotificationservice.business;

import static sk.kosice.konto.kknotificationservice.domain.permission.error.PermissionErrorCode.ACTION_IS_FORBIDDEN;
import static sk.kosice.konto.kknotificationservice.domain.permission.error.PermissionErrorCode.ACTOR_IS_EMPTY;

import java.util.Optional;
import sk.kosice.konto.kknotificationservice.business.permission.port.outbound.CheckPermissionsUseCase;
import sk.kosice.konto.kknotificationservice.domain.common.ActorIdentity;
import sk.kosice.konto.kknotificationservice.domain.permission.command.ImmutableCheckPermissionCommand;
import sk.kosice.konto.kknotificationservice.domain.shared.enumeration.Permission;

public abstract class AbstractService {

  public static final String SERVICE_NAME = "kknotification-service";

  protected void checkPermission(
      CheckPermissionsUseCase checkPermissionsUseCase,
      Optional<ActorIdentity> actorIdentity,
      Permission permission) {
    if (actorIdentity.isEmpty()) {
      throw ACTOR_IS_EMPTY.createError().convertToException();
    }

    if (!checkPermissionsUseCase.execute(
        ImmutableCheckPermissionCommand.builder()
            .actorId(actorIdentity.get().id())
            .permissionToCheck(permission)
            .build())) {
      throw ACTION_IS_FORBIDDEN
          .createError(permission.name(), actorIdentity.get().id())
          .convertToException();
    }
  }
}
