package sk.kosice.konto.kknotificationservice.business.recipient.service;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import sk.kosice.konto.kknotificationservice.business.AbstractService;
import sk.kosice.konto.kknotificationservice.business.permission.port.outbound.CheckPermissionsUseCase;
import sk.kosice.konto.kknotificationservice.business.recipient.port.inbound.CreateOrUpdateRecipientUseCase;
import sk.kosice.konto.kknotificationservice.business.recipient.port.outbound.PersistRecipientPort;
import sk.kosice.konto.kknotificationservice.business.recipient.port.outbound.QueryRecipientPort;
import sk.kosice.konto.kknotificationservice.domain.recipient.command.CreateOrUpdateRecipientCommand;
import sk.kosice.konto.kknotificationservice.domain.recipient.entity.ImmutableRecipientEntity;
import sk.kosice.konto.kknotificationservice.domain.recipient.entity.RecipientEntity;
import sk.kosice.konto.kknotificationservice.domain.shared.enumeration.Permission;

@Named
public class CreateOrUpdateRecipientService extends AbstractService
    implements CreateOrUpdateRecipientUseCase {

  private final PersistRecipientPort persistRecipientPort;
  private final QueryRecipientPort queryRecipientPort;
  private final CheckPermissionsUseCase checkPermissionsUseCase;

  @Inject
  public CreateOrUpdateRecipientService(
      PersistRecipientPort persistRecipientPort,
      QueryRecipientPort queryRecipientPort,
      CheckPermissionsUseCase checkPermissionsUseCase) {
    this.persistRecipientPort = persistRecipientPort;
    this.queryRecipientPort = queryRecipientPort;
    this.checkPermissionsUseCase = checkPermissionsUseCase;
  }

  @Override
  public RecipientEntity execute(CreateOrUpdateRecipientCommand command) {
    checkPermission(checkPermissionsUseCase, command.actorId(), Permission.ACTION_MANAGE_RECIPIENT);
    persistRecipientPort.merge(
        ImmutableRecipientEntity.builder()
            .kid(command.kid())
            .email(command.preferredEmail())
            .build());
    return queryRecipientPort.findOne(command.kid());
  }
}
