package sk.kosice.konto.kknotificationservice.domain.permission.error;

import static sk.kosice.konto.kknotificationservice.domain.common.error.ErrorCodeType.FORBIDDEN;

import sk.kosice.konto.kknotificationservice.domain.common.error.ErrorCode;
import sk.kosice.konto.kknotificationservice.domain.common.error.ErrorCodeType;

public enum PermissionErrorCode implements ErrorCode {
  USER_DOES_NOT_EXIST(FORBIDDEN, "User with ID '%s' does not exist in IdP."),
  ACTION_IS_FORBIDDEN(FORBIDDEN, "Action %s is forbidden for user with id %s."),
  ACTOR_IS_EMPTY(FORBIDDEN, "Actor is not present in request.");

  private final ErrorCodeType type;
  private final String template;

  PermissionErrorCode(ErrorCodeType type, String template) {
    this.type = type;
    this.template = template;
  }

  @Override
  public String template() {
    return this.template;
  }

  @Override
  public ErrorCodeType type() {
    return this.type;
  }
}
