package sk.kosice.konto.kknotificationservice.repository.error;

import static sk.kosice.konto.kknotificationservice.domain.common.error.ErrorCodeType.BAD_REQUEST;

import sk.kosice.konto.kknotificationservice.domain.common.error.BusinessError;
import sk.kosice.konto.kknotificationservice.domain.common.error.ErrorCode;
import sk.kosice.konto.kknotificationservice.domain.common.error.ErrorCodeType;

public interface ConstraintErrorCode extends ErrorCode {

  @Override
  default ErrorCodeType type() {
    return BAD_REQUEST;
  }

  String table();

  String constraintName();

  String[] findParams(Object dataObject);

  default boolean isErrorMatched(String errorMessage) {
    return errorMessage.contains(table()) && errorMessage.contains(constraintName());
  }

  default BusinessError createError(Object object, Throwable errorMessageFromDb) {
    return this.createError(findParams(object));
  }
}
