package sk.kosice.konto.kknotificationservice.restapi.error;

import sk.kosice.konto.kknotificationservice.domain.common.error.ErrorCode;
import sk.kosice.konto.kknotificationservice.domain.common.error.ErrorCodeType;

public enum ApiErrorCode implements ErrorCode {
  BAD_JSON_FORMAT(ErrorCodeType.BAD_REQUEST, "Invalid json format."),
  BAD_REQUEST(ErrorCodeType.BAD_REQUEST, "Invalid request parameters."),
  UNAUTHORIZED(
      ErrorCodeType.UNAUTHORIZED,
      "The credentials are invalid, or access token is missing, expired, revoked, malformed or invalid."),
  FORBIDDEN(ErrorCodeType.FORBIDDEN, "That resource data is forbidden.");

  private final ErrorCodeType type;
  private final String template;

  ApiErrorCode(ErrorCodeType type, String template) {
    this.type = type;
    this.template = template;
  }

  @Override
  public String template() {
    return this.template;
  }

  @Override
  public ErrorCodeType type() {
    return this.type;
  }
}
