package sk.kosice.konto.kkmessageservice.repository.rsql.jooq.builder;

import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.LogicalNode;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jooq.Record;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.domain.ImmutableJoin;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.domain.Join;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.metadata.JooqColumnInfo;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.metadata.JooqJoinableColumnInfo;

public class JooqRsqlJoinBuilder extends JooqRsqlWithListingMetadataBuilder<List<Join>> {

  public List<Join> build(LogicalNode logicalNode) {
    return logicalNode.getChildren().stream()
        .flatMap(c -> this.build(c).stream())
        .distinct()
        .collect(Collectors.toList());
  }

  public List<Join> build(ComparisonNode comparisonNode) {

    final String property = comparisonNode.getSelector();
    final Optional<JooqColumnInfo<?>> maybe = getMetadata().findByName(property);

    if (maybe.isEmpty()) {
      throw new IllegalArgumentException("Unknown property: " + property);
    }

    if (maybe.get() instanceof JooqJoinableColumnInfo) {
      final JooqJoinableColumnInfo<Record, Object> columnInfo =
          (JooqJoinableColumnInfo<Record, Object>) maybe.get();
      final Join join =
          ImmutableJoin.builder()
              .table(columnInfo.getTable())
              .type(columnInfo.getJoinType())
              .condition(columnInfo.getCondition())
              .build();
      return List.of(join);
    }

    return Collections.emptyList();
  }
}
