package sk.kosice.konto.kkmessageservice.restapi.dto.permission;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.immutables.value.Value;
import sk.kosice.konto.kkmessageservice.domain.common.enumeration.Permission;
import sk.kosice.konto.kkmessageservice.restapi.dto.organization.OrganizationDto;

@JsonSerialize(as = ImmutablePermissionDto.class)
@JsonDeserialize(as = ImmutablePermissionDto.class)
@Value.Immutable
public interface PermissionDto {

  @Schema(requiredMode = Schema.RequiredMode.REQUIRED)
  OrganizationDto getOrganization();

  @Schema(requiredMode = Schema.RequiredMode.REQUIRED)
  List<Permission> getPermissions();
}
