package sk.kosice.konto.kkmessageservice.restapi.springdoc.restapi.springdoc.annotation;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import sk.kosice.konto.kkmessageservice.domain.common.listing.common.ListingAttribute;

@Retention(RetentionPolicy.RUNTIME)
@Parameter(
    in = ParameterIn.QUERY,
    description =
        """
Sorting criteria in the format: property(;|:). Default sort order is ascending.
Multiple sort criteria are supported by comma. Example value 'property1,property2'.<br /><br />
<b>Supported suffixes:</b><br />
<table>
  <tr>
    <td width="100">ascending</td>
    <td><b>;</b></td>
  </tr>
  <tr>
    <td>descending</td>
    <td><b>:</b></td>
  </tr>
</table><br />
""",
    name = "sort",
    schema = @Schema(type = "string"))
public @interface SortParameter {
  Class<? extends Enum<? extends ListingAttribute>> listingAttributeClass();
}
