package sk.kosice.konto.kkmessageservice.restapi.command;

import java.util.UUID;
import sk.kosice.konto.kkmessageservice.domain.common.listing.ListFiltering;
import sk.kosice.konto.kkmessageservice.domain.common.listing.ListOrderings;
import sk.kosice.konto.kkmessageservice.domain.common.listing.PageSize;
import sk.kosice.konto.kkmessageservice.domain.common.listing.SubscriptionListingAttribute;
import sk.kosice.konto.kkmessageservice.domain.subscription.query.ImmutableSubscriptionListingQuery;
import sk.kosice.konto.kkmessageservice.domain.subscription.query.SubscriptionListingQuery;

public class SubscriptionQueryFactory {

  public static SubscriptionListingQuery map(
      UUID kid,
      ListFiltering<SubscriptionListingAttribute> filter,
      ListOrderings<SubscriptionListingAttribute> orderings,
      Integer page,
      Integer pageSize,
      Integer maxPageSize) {
    return ImmutableSubscriptionListingQuery.builder()
        .pageSize(PageSize.of(maxPageSize, pageSize))
        .recipientKid(kid)
        .addAllOrderings(orderings.asList())
        .rsqlQuery(filter.asOption())
        .page(page)
        .build();
  }
}
