package sk.kosice.konto.kkmessageservice.business.topic.service;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import sk.kosice.konto.kkmessageservice.business.AbstractService;
import sk.kosice.konto.kkmessageservice.business.topic.port.inbound.FindTopicByIdUseCase;
import sk.kosice.konto.kkmessageservice.business.topic.port.outbound.QueryTopicPort;
import sk.kosice.konto.kkmessageservice.domain.topic.entity.TopicEntity;
import sk.kosice.konto.kkmessageservice.domain.topic.query.FindTopicByIdQuery;

@Named
public class FindTopicByIdService extends AbstractService implements FindTopicByIdUseCase {

  private final QueryTopicPort queryTopicPort;

  @Inject
  public FindTopicByIdService(QueryTopicPort queryTopicPort) {
    this.queryTopicPort = queryTopicPort;
  }

  @Override
  public TopicEntity execute(FindTopicByIdQuery query) {
    return queryTopicPort.findOne(query);
  }
}
