import { PermissionType } from '@/utils';
import { useSession } from 'next-auth/react';
import { ErrorImg, Loader } from '@/lib/idsk';

function withPermission<P>(WrappedComponent: React.ComponentType<P>, permission: PermissionType) {
  const HOC: React.FC<P> = (props) => {
    const { status, data } = useSession();

    if (status === 'loading') {
      return (
        <div className="w-full h-full flex items-center justify-center">
          <Loader />
        </div>
      );
    }

    if (status === 'authenticated' && data.user.permissions.includes(permission)) {
      // @ts-ignore
      return <WrappedComponent {...props} />;
    }

    return (
      <div className="w-full h-full flex flex-col items-center justify-center">
        <ErrorImg className="max-w-48" />
        <h3>403 - Nemáte povolenie</h3>
        <p>Na zobrazenie tejto stránky nemáte povolenie.</p>
      </div>
    );
  };

  HOC.displayName = `withPermission(${WrappedComponent.displayName || WrappedComponent.name}, ${permission})`;
  return HOC;
}

export default withPermission;
