'use client';

import React from 'react';
import { useBreakpoint } from '@/hooks';
import { DataGridRowValue } from '@/lib/idsk';

const MessageListHeader: React.FC = () => {
  const { match, Breakpoints } = useBreakpoint();
  const isTablet = match(Breakpoints.tb2);

  return isTablet ? (
    <>
      <DataGridRowValue className="col-span-2">Prijímateľ</DataGridRowValue>
      <DataGridRowValue className="col-span-4">Predmet</DataGridRowValue>
      <DataGridRowValue className="col-span-2">Téma</DataGridRowValue>
      <DataGridRowValue className="col-span-2" />
      <DataGridRowValue align="right" className="col-span-2">
        Dátum
      </DataGridRowValue>
    </>
  ) : (
    <DataGridRowValue>Odosielateľ/Predmet/Téma/Dátum</DataGridRowValue>
  );
};

export default MessageListHeader;
