import React from 'react';

interface TopicsListPlaceholderProps {
  children: React.ReactNode;
}

const TopicsListPlaceholder: React.FC<TopicsListPlaceholderProps> = ({ children }) => {
  return (
    <div className="border border-neutral-300 rounded-lg overflow-hidden">
      <div className="idsk-data-grid__head hidden p-5 tb2:grid grid-cols-12">
        <div className="col-span-3 mr-6">Názov</div>
        <div className="col-span-6">Popis</div>
        <div className="col-span-3 ml-auto">Akcie</div>
      </div>
      <div className="idsk-data-grid__head block tb2:hidden">
        <div className="w-full">Názov/Popis/Akcie</div>
      </div>
      <div className="bg-white">{children}</div>
    </div>
  );
};

export default TopicsListPlaceholder;
