'use client';

/* eslint-disable no-unused-vars */
import { useCallback, useEffect, useState } from 'react';

export enum Breakpoints {
  mb = 375,
  tb1 = 520,
  tb2 = 730,
  dm1 = 1120,
  dm2 = 1440,
  dl = 1530
}

const isBreakpointActiveHelper = (screenWidth: number, breakpointWidth: number) => breakpointWidth <= screenWidth;

function useBreakpoint() {
  const [isClient, setIsClient] = useState(false);
  const [width, setWidth] = useState<number>(() => {
    if (typeof window !== 'undefined') {
      return window.innerWidth || Breakpoints.mb;
    }
    return Breakpoints.mb;
  });

  useEffect(() => {
    setIsClient(true);
  }, []);

  useEffect(() => {
    const resize = () => setWidth(window.innerWidth);
    window.addEventListener('resize', resize);
    return () => window.removeEventListener('resize', resize);
  }, []);

  const match = useCallback(
    (breakpointWidth: number) => (isClient ? isBreakpointActiveHelper(width, breakpointWidth) : false),
    [width, isClient]
  );

  return {
    width,
    Breakpoints,
    match
  };
}

export default useBreakpoint;
