import React from 'react';
import { useTranslations } from 'next-intl';
import { Dialog, DialogProps, SecondaryButton } from '@/lib/idsk';
import InfoIllustration from '@/assets/info_illustration.svg';
import SuccessIllustration from '@/assets/success_illustration.svg';
import WarningIllustration from '@/assets/warning_illustration.svg';
import ErrorIllustration from '@/assets/error_illustration.svg';
import { cn } from '@/utils';

interface InformationDialogProps extends DialogProps {
  heading: string;
  description: string;
  variant?: 'success' | 'info' | 'warning' | 'error';
}

const InformationDialogIllustration: React.FC<{ variant: Required<InformationDialogProps['variant']> }> = ({
  variant
}) => {
  switch (variant) {
    case 'info':
      return <InfoIllustration />;
    case 'warning':
      return <WarningIllustration />;
    case 'error':
      return <ErrorIllustration />;
    default:
      return <SuccessIllustration />;
  }
};

const InformationDialog: React.FC<InformationDialogProps> = ({
  heading,
  description,
  className,
  variant = 'info',
  ...props
}) => {
  const t = useTranslations('utils');

  return (
    <Dialog
      className={cn('custom-dialog', className)}
      secondaryButton={<SecondaryButton onClick={props.toggleOpened}>{t('close')}</SecondaryButton>}
      {...props}
    >
      <div className="flex flex-col gap-7 items-center max-w-lg tb2:min-w-[28rem]">
        <InformationDialogIllustration variant={variant} />
        <div className="text-center mx-auto">
          <h4 className="mb-2">{heading}</h4>
          <p>{description}</p>
        </div>
      </div>
    </Dialog>
  );
};

export default InformationDialog;
