import { useTranslations } from 'next-intl';
import React from 'react';
import { WithUser, Card, Data, DataItem } from '@/components/core';
import { Section } from '@/components/layout';
import BirthNumber from './BirthNumber';

const PersonalData: React.FC = () => {
  const t = useTranslations('homepage');

  return (
    <WithUser>
      {(user) => (
        <Section>
          <Card title={t('personal_data')}>
            <Data>
              <DataItem label={t('name')}>{user.name}</DataItem>
              <DataItem label={t('surname')}>{user.surname}</DataItem>
              <DataItem label={t('birth_number')}>
                <BirthNumber value={user.pin} />
              </DataItem>
            </Data>
          </Card>
        </Section>
      )}
    </WithUser>
  );
};

export default PersonalData;
