package sk.kosice.konto.kkmessageservice.repository.error;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.kosice.konto.kkmessageservice.domain.common.error.BusinessException;

public final class RepositoryErrorHandler {

  protected static final Logger log = LoggerFactory.getLogger(RepositoryErrorHandler.class);

  public RepositoryErrorHandler() {}

  public static Throwable handle(
      Throwable t, Object dataObject, ConstraintErrorCode... errorCodes) {
    for (ConstraintErrorCode constraintErrorCode : errorCodes) {
      if (constraintErrorCode.isErrorMatched(t.getMessage())) {
        log.debug("Matched constraint error code: '{}'.", constraintErrorCode);

        return constraintErrorCode.createError(dataObject, t).convertToException();
      }
    }
    return handle(t);
  }

  public static Throwable handle(Throwable throwable) {
    if (throwable instanceof BusinessException) {
      // Exception is already mapped.
      return throwable;
    }
    log.error("Unhandled db error: '{}'.", throwable.getMessage());
    return DbErrorCode.UNHANDLED_DB_ERROR.createError().convertToException();
  }
}
