package sk.kosice.konto.kkmessageservice.restapi.command;

import java.util.Optional;
import java.util.UUID;
import sk.kosice.konto.kkmessageservice.domain.common.audit.ImmutableActorIdentity;
import sk.kosice.konto.kkmessageservice.domain.message.command.ImmutableCreateMessageCommand;
import sk.kosice.konto.kkmessageservice.restapi.common.ObjectMapperHelper;
import sk.kosice.konto.kkmessageservice.restapi.dto.message.MessageCreateRequest;

public final class MessageCommandFactory {

  public static ImmutableCreateMessageCommand createMessageCommand(
      UUID organizationId, UUID kid, Optional<String> actorId, MessageCreateRequest request) {
    return ImmutableCreateMessageCommand.builder()
        .title(request.getTitle())
        .topicId(request.getTopicId())
        .body(request.getBody())
        .organizationId(organizationId)
        .bodyType(request.getBodyType())
        .bodyShort(request.getBodyShort())
        .actions(request.getActions().map(ObjectMapperHelper::parseStringFromJsonNodeList))
        .tags(request.getTags().map(ObjectMapperHelper::parseStringFromJsonNodeList))
        .recipientKid(Optional.ofNullable(kid))
        .addAllLocations(request.getLocations())
        .actorId(actorId.map(ImmutableActorIdentity::of))
        .build();
  }
}
