package sk.kosice.konto.kkmessageservice.restapi.common;

import static sk.kosice.konto.kkmessageservice.restapi.error.ApiErrorCode.BAD_JSON_FORMAT;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;

public final class ObjectMapperHelper {

  private static final ObjectMapper objectMapper = new ObjectMapper();

  public static JsonNode createJsonNodeFromString(String s) {
    try {
      return objectMapper.readTree(s);
    } catch (JsonProcessingException e) {
      throw BAD_JSON_FORMAT.createError().convertToException();
    }
  }

  public static List<JsonNode> createJsonNodeListFromString(String s) {
    try {
      return objectMapper.readValue(s, new TypeReference<>() {});
    } catch (JsonProcessingException e) {
      throw BAD_JSON_FORMAT.createError().convertToException();
    }
  }

  public static String parseStringFromJsonNode(JsonNode jsonNode) {
    try {
      return objectMapper.writeValueAsString(jsonNode);
    } catch (JsonProcessingException e) {
      throw BAD_JSON_FORMAT.createError().convertToException();
    }
  }

  public static String parseStringFromJsonNodeList(List<JsonNode> jsonNode) {
    try {
      return objectMapper.writeValueAsString(jsonNode);
    } catch (JsonProcessingException e) {
      throw BAD_JSON_FORMAT.createError().convertToException();
    }
  }
}
