package sk.kosice.konto.kkmessageservice.organization;

import static org.assertj.core.api.Assertions.assertThat;
import static sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCodeType.UNAUTHORIZED;

import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.springframework.http.HttpStatus;
import sk.kosice.konto.kkmessageservice.restapi.dto.common.error.ErrorDetailResponse;
import sk.kosice.konto.kkmessageservice.restapi.dto.organization.OrganizationListResponse;
import sk.kosice.konto.kkmessageservice.restapi.dto.subscription.SubscriptionDetailResponse;
import sk.kosice.konto.kkmessageservice.subscription.SubscriptionApiFixtures;

public class OrganizationListingFeatureSpec extends OrganizationFeatureSpec {

  @Test
  public void thatEmptyOrganizationsListCanBeRetrievedWithEmployeeToken() {
    prepareEmptyOrganizationListResponse();

    final var response = listOrganizations(HttpStatus.OK, OrganizationListResponse.class);
    assertThat(response).isNotNull();
    assertThat(response.items()).isNotNull().isEmpty();
  }

  @Test
  public void thatOrganizationsListCanBeRetrievedWithEmployeeToken() {
    prepareOrganizationListResponse();

    final var response = listOrganizations(HttpStatus.OK, OrganizationListResponse.class);
    assertThat(response).isNotNull();
    assertThat(response.items()).isNotNull().hasSize(3);
  }

  @Disabled("Temporary disabled")
  @Test
  public void thaOrganizationsListCanNotBeRetrievedWithoutJwt() {
    prepareOrganizationListResponse();

    final var response =
        listOrganizationsWithoutJwt(HttpStatus.UNAUTHORIZED, ErrorDetailResponse.class);
    assertThat(response).isNotNull();
    assertThat(response.primaryFault().get().faultCode()).isEqualTo(UNAUTHORIZED.toString());
  }

  @Test
  public void thatUniqueOrganizationsCanBeRetrievedForKid() {
    final List<UUID> topics1 = prepareTopics(ORGANIZATION_ID_1);
    final List<UUID> topics2 = prepareTopics(ORGANIZATION_ID_2);
    prepareRecipient(UUID.fromString(EXTENSION_KID_CLAIM));

    final List<SubscriptionDetailResponse> subscriptions1 =
        List.of(
            createSubscriptions(
                HttpStatus.CREATED,
                UUID.fromString(EXTENSION_KID_CLAIM),
                SubscriptionDetailResponse[].class,
                SubscriptionApiFixtures.subscriptionCreateByOrganizationIdRequest(
                    ORGANIZATION_ID_1)));
    final List<SubscriptionDetailResponse> subscriptions2 =
        List.of(
            createSubscriptions(
                HttpStatus.CREATED,
                UUID.fromString(EXTENSION_KID_CLAIM),
                SubscriptionDetailResponse[].class,
                SubscriptionApiFixtures.subscriptionCreateByOrganizationIdRequest(
                    ORGANIZATION_ID_2)));

    final OrganizationListResponse response =
        listOrganizationsByKid(
            HttpStatus.OK, OrganizationListResponse.class, UUID.fromString(EXTENSION_KID_CLAIM));
    assertThat(response.items()).hasSize(2);
  }
}
