package sk.kosice.konto.kkmessageservice.subscription;

import java.util.List;
import java.util.UUID;
import sk.kosice.konto.kkmessageservice.restapi.dto.subscription.ImmutableSubscriptionBatchUpdateRequest;
import sk.kosice.konto.kkmessageservice.restapi.dto.subscription.ImmutableSubscriptionCreateByOrganizationIdRequest;
import sk.kosice.konto.kkmessageservice.restapi.dto.subscription.ImmutableSubscriptionUpdateRequest;
import sk.kosice.konto.kkmessageservice.restapi.dto.subscription.SubscriptionBatchUpdateRequest;
import sk.kosice.konto.kkmessageservice.restapi.dto.subscription.SubscriptionCreateByOrganizationIdRequest;
import sk.kosice.konto.kkmessageservice.restapi.dto.subscription.SubscriptionUpdateRequest;

public class SubscriptionApiFixtures {

  public static SubscriptionBatchUpdateRequest subscriptionBatchUpdateRequest(UUID id) {
    return ImmutableSubscriptionBatchUpdateRequest.builder().id(id).isEmailEnabled(true).build();
  }

  public static SubscriptionUpdateRequest subscriptionUpdateRequest() {
    return ImmutableSubscriptionUpdateRequest.builder().isEmailEnabled(true).build();
  }

  public static SubscriptionCreateByOrganizationIdRequest subscriptionCreateByOrganizationIdRequest(
      UUID... organizationIds) {
    return ImmutableSubscriptionCreateByOrganizationIdRequest.builder()
        .addAllOrganizations(List.of(organizationIds))
        .build();
  }
}
