package sk.kosice.konto.kkmessageservice.business.subscription.service;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import sk.kosice.konto.kkmessageservice.business.AbstractService;
import sk.kosice.konto.kkmessageservice.business.recipient.port.outbound.QueryRecipientPort;
import sk.kosice.konto.kkmessageservice.business.subscription.port.inbound.SubscriptionInitializationForRecipientUseCase;
import sk.kosice.konto.kkmessageservice.business.subscription.port.outbound.PersistSubscriptionPort;
import sk.kosice.konto.kkmessageservice.domain.subscription.command.SubscriptionInitializationForRecipientCommand;

@Named
public class SubscriptionInitializationForRecipientService extends AbstractService
    implements SubscriptionInitializationForRecipientUseCase {

  private final QueryRecipientPort queryRecipientPort;
  private final PersistSubscriptionPort persistSubscriptionPort;

  @Inject
  public SubscriptionInitializationForRecipientService(
      QueryRecipientPort queryRecipientPort, PersistSubscriptionPort persistSubscriptionPort) {
    this.queryRecipientPort = queryRecipientPort;
    this.persistSubscriptionPort = persistSubscriptionPort;
  }

  @Override
  public void execute(SubscriptionInitializationForRecipientCommand command) {
    final var recipient = queryRecipientPort.findOne(command.recipientKid());

    persistSubscriptionPort.initSubscriptionsForRecipient(recipient.kid());
  }
}
