package sk.kosice.konto.kkmessageservice.domain.message.entity;

import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;
import org.immutables.value.Value;
import sk.kosice.konto.kkmessageservice.domain.common.listing.PaginatedResultItem;
import sk.kosice.konto.kkmessageservice.domain.common.marker.DomainEntity;

@Value.Immutable
public interface BaseMessageEntity extends DomainEntity, PaginatedResultItem {

  UUID id();

  String senderName();

  String title();

  UUID topicId();

  String topicName();

  Optional<String> tags();

  OffsetDateTime createdAt();

  UUID organizationId();

  Optional<UUID> recipientKid();

  static BaseMessageEntity of(MessageEntity entity) {
    return ImmutableBaseMessageEntity.builder()
        .id(entity.id())
        .senderName(entity.senderName())
        .title(entity.title())
        .topicId(entity.topicId())
        .topicName(entity.topicName())
        .createdAt(entity.createdAt())
        .organizationId(entity.organizationId())
        .tags(entity.tags())
        .recipientKid(entity.recipientKid())
        .build();
  }
}
