'use client';
import React, { ChangeEvent, useState } from 'react';
import { Cookies, useCookies, useNotifications } from '@/hooks';
import { Checkbox, PrimaryButton } from '@/lib/idsk';
import { useTranslations } from 'next-intl';
import { useRouter } from 'next/navigation';

type Props = {
  title: string;
  children: string;
  checked: boolean;
  disabled?: boolean;
  onChange?: (e: ChangeEvent<HTMLInputElement>) => void;
};

const CookieSettingsItem: React.FC<Props> = ({ title, children, checked, disabled, onChange }) => {
  return (
    <div className="flex flex-col gap-2">
      <h3>{title}</h3>
      <div className="flex">
        <Checkbox checked={checked} disabled={disabled} onChange={onChange} />
        <p>{children}</p>
      </div>
    </div>
  );
};

const CookieSettings: React.FC = () => {
  const { cookies, update } = useCookies();
  const [state, setState] = useState<Cookies>(cookies || { necessary: true, analytics: true, preferential: false });

  const notify = useNotifications();
  const t = useTranslations('cookies');

  const router = useRouter();

  const changeState = (key: keyof Cookies, value: boolean) => {
    setState((p) => ({ ...p, [key]: value }));
  };

  const save = () => {
    update(state);
    notify(t('cookiesSaved'));
    router.push('/');
  };

  return (
    <div className="flex flex-col gap-7">
      <CookieSettingsItem title={t('settingsItem1Title')} checked disabled>
        {t('settingsItem1')}
      </CookieSettingsItem>

      <CookieSettingsItem
        title={t('settingsItem2Title')}
        checked={!!state?.analytics}
        onChange={(e) => changeState('analytics', e.target.checked)}
      >
        {t('settingsItem2')}
      </CookieSettingsItem>

      <CookieSettingsItem
        title={t('settingsItem3Title')}
        checked={!!state?.preferential}
        onChange={(e) => changeState('preferential', e.target.checked)}
      >
        {t('settingsItem3')}
      </CookieSettingsItem>

      <PrimaryButton className="tb1:w-fit" size="large" onClick={save}>
        {t('saveSettings')}
      </PrimaryButton>
    </div>
  );
};

export default CookieSettings;
