import React from 'react';
import Link, { LinkProps } from 'next/link';
import { SecondaryButton } from '@/lib/idsk';
import { cn } from '@/utils';

interface LinkCardProps extends LinkProps {
  icon: React.ReactNode;
  title: string;
  label: string;
  children: string;
  className?: string;
}

const LinkCard: React.FC<LinkCardProps> = ({ icon, title, label, children, className, ...props }) => (
  <div
    className={cn(
      'bg-primary-light border border-blue-300 rounded-lg px-5 py-5 tb2:px-10 tb2:py-7 idsk-text-body flex flex-col gap-7',
      className
    )}
  >
    <div className="flex flex-col gap-5">
      <div>{icon}</div>
      <div className="flex flex-col gap-2">
        <h3>{title}</h3>
        <div>{children}</div>
      </div>
    </div>
    <Link className="mt-auto" {...props}>
      <SecondaryButton>{label}</SecondaryButton>
    </Link>
  </div>
);

export default LinkCard;
