'use client';

import React, { useRef, useState } from 'react';
import { MessageDetailAction } from './message-detail-actions';
import { MessageAction } from '@/utils';

interface MessageBodyProps {
  body: string;
  actions: MessageAction[];
}

const MessageBody: React.FC<MessageBodyProps> = ({ body, actions }) => {
  const iframeRef = useRef<HTMLIFrameElement | null>(null);

  const onLoad = () => {
    const iframe = iframeRef.current;
    if (!iframe) return;

    try {
      const iframeDoc = iframe.contentDocument || iframe.contentWindow?.document;
      if (iframeDoc) {
        const height = iframeDoc.documentElement.scrollHeight;
        iframe.style.height = `${height}px`;
      }
    } catch (err) {
      console.warn('Could not access iframe contents', err);
    }
  };

  return (
    <div style={{ width: '100%', maxWidth: 'none' }} className="p-7 flex flex-col gap-4 message-detail">
      <iframe ref={iframeRef} srcDoc={body} onLoad={onLoad} sandbox="allow-same-origin" />
      {actions.length > 0 && (
        <div className="flex flex-col gap-4">
          {actions.map((action) => (
            <MessageDetailAction key={action.type} action={action} />
          ))}
        </div>
      )}
    </div>
  );
};

export default MessageBody;
