import React from 'react';
import { DropDown, FlagIcon, Tag, TertiaryIconButton } from '@/lib/idsk';
import { v4 } from 'uuid';

interface ProceedingsTagsProps {
  item: any;
}

const ProceedingsTagsList: React.FC<{ item: any }> = ({ item }) => (
  <div className="flex justify-end flex-wrap gap-2 overflow-hidden pointer-events-none">
    {item.statuses.map((status: any) => (
      <Tag key={v4()} variant={status.variant} className="text-left" label={status.status} size="small" />
    ))}
  </div>
);

const ProceedingsTags: React.FC<ProceedingsTagsProps> = ({ item }) => (
  <>
    <div className="dm1:block hidden">
      <ProceedingsTagsList item={item} />
    </div>
    <div className="hidden tb2:block dm1:hidden">
      <DropDown
        customTrigger={
          <TertiaryIconButton
            className="hover:bg-neutral-200 active:bg-neutral-300"
            variant="neutral"
            icon={<FlagIcon />}
          />
        }
        optionsSide="left"
      >
        <ProceedingsTagsList item={item} />
      </DropDown>
    </div>
  </>
);

export default ProceedingsTags;
