import React, { useCallback } from 'react';
import { useLocale, useTranslations } from 'next-intl';
import { usePathname } from 'next/navigation';
import { SecondaryNavigation } from '@/lib/idsk';

const SecondaryHeader: React.FC = () => {
  const t = useTranslations();
  const locale = useLocale();
  const pathname = usePathname();

  const getLanguageLinks = useCallback(() => {
    const locales: string[] = ['sk', 'en'];

    return locales
      .filter((lang) => lang !== locale)
      .map((lang) => (
        <a key={`lang-${lang}`} href={pathname.replace(locale, lang)}>
          {t(lang)}
        </a>
      ));
  }, [pathname, locale, t]);

  return (
    <SecondaryNavigation
      id="secondary-navigation-container"
      className="bg-primary-medium"
      heading={t('official_page')}
      headingButton={t('official_page_button')}
      mobileHeadingButton={t('kosice_city')}
      dropDownTitle={t(locale)}
      dropDownOptions={getLanguageLinks()}
    />
  );
};

export default SecondaryHeader;
