import React from 'react';
import { cn } from '@/utils';

interface SectionProps extends React.HTMLAttributes<HTMLDivElement> {
  heading?: string;
  h?: React.ElementType;
  description?: React.ReactNode | string;
  children?: React.ReactNode;
}

const Section: React.FC<SectionProps> = ({ heading, description, children, className, h, ...props }) => {
  const Component = h || 'h3';

  return (
    <section className={cn('flex flex-col gap-5 w-full', className)} {...props}>
      {heading || description ? (
        <div className="flex flex-col gap-2">
          {heading ? <Component>{heading}</Component> : null}
          {description ? <p className="idsk-text-body">{description}</p> : null}
        </div>
      ) : null}
      {children}
    </section>
  );
};

export default Section;
