package sk.kosice.konto.kkmessageservice.idp.config;

import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.graph.serviceclient.GraphServiceClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import sk.kosice.konto.kkmessageservice.idp.config.properties.AzureIdpPropertiesPort;

@Configuration
public class AzureIdpConfiguration {

  @Profile("!test")
  @Bean
  public GraphServiceClient graphServiceClient(AzureIdpPropertiesPort azureIdpPropertiesPort) {
    final String[] scopes = azureIdpPropertiesPort.scopes().split(",");

    final ClientSecretCredential credential =
        new ClientSecretCredentialBuilder()
            .tenantId(azureIdpPropertiesPort.tenantId())
            .clientId(azureIdpPropertiesPort.clientId())
            .clientSecret(azureIdpPropertiesPort.clientSecret())
            .build();

    return new GraphServiceClient(credential, scopes);
  }
}
