package sk.kosice.konto.kkmessageservice.idp.organization;

import static org.assertj.core.api.Assertions.assertThat;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.junit.jupiter.api.Test;
import sk.kosice.konto.kkmessageservice.domain.organization.entity.OrganizationEntity;
import sk.kosice.konto.kkmessageservice.idp.AzureIdpAdapterTest;

public class IdpOrganizationRepositoryTest extends AzureIdpAdapterTest {

  @Test
  public void testListOfOrganizationCanBeRetrievedFromAzure() {
    prepareListResponse();
    final List<OrganizationEntity> response = azureIdpRepository.list(Optional.empty());

    assertThat(response).isNotNull().isNotEmpty().hasSize(3);
    response.stream()
        .forEach(
            organization -> {
              assertThat(organization.id()).isNotNull().isNotNull();
              assertThat(organization.name()).isNotNull().isNotNull().isNotEmpty();
            });
  }

  @Test
  public void testListOfOrganizationCanBeRetrievedByRootGroupIdFromAzure() {
    prepareListByRootGroupResponse();
    final List<OrganizationEntity> response =
        azureIdpRepository.list(Optional.of(UUID.fromString(ROOT_GROUP_ID)));

    assertThat(response).isNotNull().isNotEmpty().hasSize(2);
    response.stream()
        .forEach(
            organization -> {
              assertThat(organization.id()).isNotNull().isNotNull();
              assertThat(organization.name()).isNotNull().isNotNull().isNotEmpty();
            });
  }

  @Test
  public void thatOrganizationCanBeRetrievedById() {
    final var groupId = UUID.randomUUID();
    prepareFindOneResponse(groupId);

    final var response = azureIdpRepository.findOne(groupId);
    assertThat(response).isNotNull();
    assertThat(response.id()).isEqualTo(groupId);
    assertThat(response.name()).isEqualTo("groupName");
  }
}
