package sk.kosice.konto.kkmessageservice.repository.rsql.converter;

import java.util.UUID;
import sk.kosice.konto.kkmessageservice.repository.rsql.RsqlErrorCode;

public class UUIDValueConverter implements FieldValueConverter<UUID> {

  @Override
  public boolean isAccessibleFor(Class clazz) {
    return UUID.class.isAssignableFrom(clazz);
  }

  @Override
  public UUID from(String from) {
    try {
      return UUID.fromString(from);
    } catch (IllegalArgumentException e) {
      throw RsqlErrorCode.INVALID_RSQL_UUID_VALUE_EXCEPTION.createError(from).convertToException();
    }
  }
}
