package sk.kosice.konto.kkmessageservice.repository.rsql.jooq;

import sk.kosice.konto.kkmessageservice.repository.rsql.RsqlAbstractNodeParser;
import sk.kosice.konto.kkmessageservice.repository.rsql.converter.BooleanValueConverter;
import sk.kosice.konto.kkmessageservice.repository.rsql.converter.DateTimeValueConverter;
import sk.kosice.konto.kkmessageservice.repository.rsql.converter.LocalDateValueConverter;
import sk.kosice.konto.kkmessageservice.repository.rsql.converter.UUIDValueConverter;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.builder.JooqRsqlListingMetadataAwareBuilder;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.metadata.JooqRsqlMetadata;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.metadata.JooqRsqlMetadataAware;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.metadata.JooqRsqlMetadataConfigProvider;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.metadata.JooqRsqlMetadataImpl;

public class JooqRsqlWithMetadataParser<T> extends RsqlAbstractNodeParser<T> {

  private JooqRsqlMetadataConfigProvider jooqListingMetadataConfigProvider;

  public JooqRsqlWithMetadataParser(
      JooqRsqlListingMetadataAwareBuilder<T> jooqRsqlBuilder,
      JooqRsqlMetadataConfigProvider jooqListingMetadataConfigProvider) {
    super(jooqRsqlBuilder);
    this.jooqListingMetadataConfigProvider = jooqListingMetadataConfigProvider;
    this.configureJooqRsqlMetadataAwareBuilder(jooqRsqlBuilder);
  }

  private void configure(JooqRsqlMetadata metadata) {
    metadata
        .registerConverter(new BooleanValueConverter())
        .registerConverter(new DateTimeValueConverter())
        .registerConverter(new UUIDValueConverter())
        .registerConverter(new LocalDateValueConverter());

    jooqListingMetadataConfigProvider.configure(metadata);
  }

  private void configureJooqRsqlMetadataAwareBuilder(
      JooqRsqlMetadataAware jooqListingMetadataAware) {
    final JooqRsqlMetadata columnInfoMetadata = new JooqRsqlMetadataImpl();
    configure(columnInfoMetadata);
    jooqListingMetadataAware.setJooqRsqlMetadata(columnInfoMetadata);
  }
}
