package sk.kosice.konto.kkmessageservice.repository.rsql.jooq.handler;

import cz.jirutka.rsql.parser.RSQLParserException;
import cz.jirutka.rsql.parser.ast.Node;
import java.util.Optional;
import org.jooq.SelectQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.kosice.konto.kkmessageservice.domain.common.error.BusinessException;
import sk.kosice.konto.kkmessageservice.repository.rsql.RsqlErrorCode;
import sk.kosice.konto.kkmessageservice.repository.rsql.RsqlNodeParser;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.JooqRsqlWithMetadataParser;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.builder.JooqRsqlSelectBuilder;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.builder.JooqRsqlWithListingMetadataBuilder;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.metadata.JooqRsqlMetadataConfigProvider;

public class JooqRsqlSelectQueryHandler implements JooqOneParamSelectQueryHandler<SelectQuery> {

  private static final Logger log = LoggerFactory.getLogger(JooqRsqlSelectQueryHandler.class);

  private final Optional<Node> rsqlQuery;
  private final JooqRsqlMetadataConfigProvider rsqlParserConfiguration;

  public JooqRsqlSelectQueryHandler(
      Optional<Node> rsqlQuery, JooqRsqlMetadataConfigProvider rsqlParserConfiguration) {
    this.rsqlQuery = rsqlQuery;
    this.rsqlParserConfiguration = rsqlParserConfiguration;
  }

  public SelectQuery handle(SelectQuery query) throws BusinessException {
    if (rsqlQuery.isPresent()) {
      final JooqRsqlWithListingMetadataBuilder<SelectQuery> builder =
          new JooqRsqlSelectBuilder(query);
      final RsqlNodeParser<SelectQuery> rsqlParser =
          new JooqRsqlWithMetadataParser<>(builder, rsqlParserConfiguration);
      try {
        rsqlParser.parse(rsqlQuery.get());
      } catch (RSQLParserException e) {
        log.error(e.getMessage(), e);
        throw RsqlErrorCode.PARSE_RSQL_EXCEPTION.createError().convertToException();
      }
    } else {
      log.debug(
          "Adjusting select with RSQL condition skipped. There is not any RSQL query defined.");
    }
    return query;
  }
}
