package sk.kosice.konto.kkmessageservice.restapi.command;

import java.util.UUID;
import sk.kosice.konto.kkmessageservice.domain.common.audit.ImmutableActorIdentity;
import sk.kosice.konto.kkmessageservice.domain.common.listing.ListFiltering;
import sk.kosice.konto.kkmessageservice.domain.common.listing.ListOrderings;
import sk.kosice.konto.kkmessageservice.domain.common.listing.PageSize;
import sk.kosice.konto.kkmessageservice.domain.common.listing.TopicListingAttribute;
import sk.kosice.konto.kkmessageservice.domain.topic.query.ImmutableTopicListingQuery;
import sk.kosice.konto.kkmessageservice.domain.topic.query.TopicListingQuery;

public class TopicQueryFactory {

  public static TopicListingQuery map(
      UUID organizationId,
      String actorId,
      ListFiltering<TopicListingAttribute> filter,
      ListOrderings<TopicListingAttribute> orderings,
      Integer page,
      Integer pageSize,
      Integer maxPageSize) {
    return ImmutableTopicListingQuery.builder()
        .pageSize(PageSize.of(maxPageSize, pageSize))
        .organizationId(organizationId)
        .addAllOrderings(orderings.asList())
        .rsqlQuery(filter.asOption())
        .page(page)
        .actorId(ImmutableActorIdentity.of(actorId))
        .build();
  }
}
