package sk.kosice.konto.kkmessageservice.scheduler;

import net.javacrumbs.shedlock.spring.annotation.EnableSchedulerLock;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import sk.kosice.konto.kkmessageservice.business.topic.port.inbound.SynchronizeTopicOrganizationNameUseCase;

@EnableScheduling
@Configuration
@EnableSchedulerLock(
    defaultLockAtMostFor = "${sk.kosice.message.scheduler.default-lock-at-most-for}")
public class ScheduledJobs {

  @Bean
  @ConditionalOnProperty(
      value = {
        "sk.kosice.message.scheduler.organization-name-synchronizer.enabled",
      },
      matchIfMissing = true,
      havingValue = "true")
  public SynchronizeTopicOrganizationNameJob synchronizeTopicOrganizationNamesJob(
      SynchronizeTopicOrganizationNameUseCase synchronizeTopicOrganizationNameUseCase) {
    return new SynchronizeTopicOrganizationNameJob(synchronizeTopicOrganizationNameUseCase);
  }
}
