package sk.kosice.konto.kkmessageservice;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jooq.JooqAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import sk.kosice.konto.kkmessageservice.restapi.common.listing.ListFilteringParser;
import sk.kosice.konto.kkmessageservice.restapi.common.listing.ListOrderingParser;
import sk.kosice.konto.kkmessageservice.restapi.springdoc.restapi.springdoc.FilterParameterCustomizer;
import sk.kosice.konto.kkmessageservice.restapi.springdoc.restapi.springdoc.SortParameterCustomizer;

@SpringBootApplication(
    scanBasePackageClasses = {
      KkMessageServiceApplication.class,
      ListFilteringParser.class,
      ListOrderingParser.class,
      FilterParameterCustomizer.class,
      SortParameterCustomizer.class,
    },
    exclude = {JooqAutoConfiguration.class, DataSourceAutoConfiguration.class})
@EnableConfigurationProperties
public class KkMessageServiceApplication {
  public static void main(String[] args) {
    SpringApplication.run(KkMessageServiceApplication.class);
  }
}
